# 外部モジュール
import os
import shutil
import pyautogui
import pyperclip
import datetime
from robot.libraries.BuiltIn import BuiltIn

def valtes_select_combobox_item_by_name(location, value):
    """
    コンボボックスをアイテム名で選択する

    Parameters
    ------------------
    screen : string
        画面名
    element : string
        項目名
    value : string
        コンボボックスのアイテム名
    """
    BuiltIn().import_library("FlaUILibrary")
    winlib = BuiltIn().get_library_instance("FlaUILibrary")
    data = winlib.get_all_texts_from_combobox(identifier=location)
    is_item_check = False
    for index, item in enumerate(data):
        if item == value:
            item_index = index
            is_item_check = True
            break
    if is_item_check is False:
        BuiltIn().fail(f"{value} does not exist in the combobox")
    winlib.select_combobox_item_by_index(identifier=location, index=item_index)